<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubFilterRecurring extends Model 
{

    protected $table = 'sub_filters_recurring';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'filter_recurring_id');

    public function filtersRecurring()
    {
        return $this->belongsTo('App\Models\FilterRecurring', 'filter_recurring_id');
    }

    public function subFilters()
    {
        return $this->hasMany('App\Models\SubFilter', 'recurring_sub_filter_id');
    }

}